﻿using Connection.Class.GATT;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows;
using System.Windows.Controls;

namespace WBP_Home_A_BT_API_Demo {

    /// <summary>
    /// Window_BluetoothDiscover.xaml 的互動邏輯
    /// </summary>
    public partial class Window_BluetoothDiscover : Window {

        public Window_BluetoothDiscover() {
            InitializeComponent();
            Connection.BLE_Scanner.InitScan(new List<string>(new string[] { "WatchBP Home" }));
            Connection.BLE_Scanner.DeviceAdded += OnDeviceAdded;
            Connection.BLE_Scanner.DeviceRemoved += OnDeviceRemoved;
            Connection.BLE_Scanner.SignalStrengthUpdated += DeviceWatcher_SignalStrengthUpdated;
            Connection.BLE_Scanner.StartScan();
        }

        public string BLE_ID { get; set; }
        public BLEAction BLEAction { get; set; }

        private delegate void DoActionHandler(ListBox lb, Action action);

        private void DeviceWatcher_SignalStrengthUpdated(object sender, Dictionary<ulong, int> e) {
        }

        private void OnDeviceRemoved(object sender, DeviceRemovedEventArgs e) {
            UpdateUI(listBox1, () => {
                for (int i = 0; i < listBox1.Items.Count; i++) {
                    if (listBox1.Items[i].ToString().Contains(e.Device.Id)) {
                        listBox1.Items.Remove(listBox1.Items[i]);
                        return;
                    }
                }
            });
        }

        private void OnDeviceAdded(object sender, DeviceAddedEventArgs e) {
            UpdateUI(listBox1, () => listBox1.Items.Add($"{e.Device.Name} -- {e.Device.Address:X} -- {e.Device.Id}"));
        }


        public static void UpdateUI(ListBox tb, Action action) {
            tb.Dispatcher.Invoke(action);
        }

        private void Button1_Click(object sender, EventArgs e) {
            if (listBox1.SelectedItem == null)
                return;
            BLE_ID = listBox1.SelectedItem.ToString().Split(new string[] { " -- " }, StringSplitOptions.RemoveEmptyEntries).Last();
            BLEAction = BLEAction.Connect;
            Close();
        }
    }

    public enum BLEAction {
        None,
        Connect,
        Disconnect,
        Pair,
        Unpair
    }
}